import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values, bind_dataframe, pivot_a_level, fill_missing_values

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
employment_group = bind_dataframe(credit_customers, 'employment')  
employment_counts = count_unique_values(employment_group['class'], normalize=True)  
approval_rates_employment = fill_missing_values(pivot_a_level(employment_counts), value=0)['good']  
 
print(approval_rates_employment)
pickle.dump(approval_rates_employment,open("./ref_result/approval_rates_employment.pkl","wb"))

  